﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace Rozdzial_19
{
    class Program
    {
        static void Main(string[] args)
        {
            List<StaffMember> hospitalStaff = new List<StaffMember>
            {
                new StaffMember { Name = "Marek", Position="Lekarz" },
                new StaffMember { Name = "Natalia", Position = "Pielegniarka" },
                new StaffMember { Name = "Marcela", Position = "Pielegniarka" }
            };

            // podstawowe zapytanie

            IEnumerable<StaffMember> staffMbrList =
                from staffMbr in hospitalStaff
                select staffMbr;

            foreach (var mbr in staffMbrList)
            {
                Console.WriteLine(mbr.Name);
            }

            // projekcja

            IEnumerable<StaffMbrAbbr> staffMbrAbbrList =
                from staffMbr in hospitalStaff
                select new StaffMbrAbbr { Name = staffMbr.Name };

            var staffNameList =
                from staffMbr in hospitalStaff
                select new { Name = staffMbr.Name };

            foreach (var mbr in staffNameList)
            {
                Console.WriteLine(mbr.Name);   
            }

            // filtrowanie

            var nurses =
                from staffMbr in hospitalStaff
                where staffMbr.Position == "Pielegniarka"
                select staffMbr.Name;

            foreach (var name in nurses)
            {
                Console.WriteLine(name);
            }

            // sortowanie

            var orderedNurses =
                from staffMbr in hospitalStaff
                where staffMbr.Position == "Pielegniarka"
                orderby staffMbr.Name
                select staffMbr.Name;

            foreach (var nurse in orderedNurses)
            {
                Console.WriteLine("Imię: {0}", nurse);
            }

            var orderedStaff =
                from staffMbr in hospitalStaff
                orderby staffMbr.Position descending, staffMbr.Name
                select new { staffMbr.Name, staffMbr.Position };

            foreach (var staff in orderedStaff)
            {
                Console.WriteLine("Imię: {0}, Stanowisko: {1}", staff.Name, staff.Position);
            }

            // grupowanie

            var groupedStaff =
                from staffMbr in hospitalStaff
                group staffMbr by staffMbr.Position into staffMbrGroup
                select staffMbrGroup.Key;

            foreach (var staff in groupedStaff)
            {
                Console.WriteLine("Group: {0}", staff);
            }

            // łączenie

            List<PatientObject> patients = new List<PatientObject>
            {
                new PatientObject { Doctor = "Marek", Name = "Grzegorz" },
                new PatientObject { Doctor = "Tobiasz", Name = "Kacper" },
                new PatientObject { Doctor = "Marek", Name = "Janina" }
            };

            var patientsAndDoctors =
                from doctor in hospitalStaff
                join patient in patients on doctor.Name equals patient.Doctor
                select new { Doctor = doctor.Name, Patient = patient.Name };

            foreach (var patientDoc in patientsAndDoctors)
            {
                Console.WriteLine("Lekarz: {0}, Pacjent: {1}",
                        patientDoc.Doctor, patientDoc.Patient); 
            }

            var patientsGroupedByDoctors = 
                from doctor in hospitalStaff
                join patient in patients on doctor.Name equals patient.Doctor into PatientGroup
                select new { Doctor = doctor.Name, Patients = PatientGroup };

            foreach (var doc in patientsGroupedByDoctors)
            {
                foreach (var patient in doc.Patients)
                {
                    Console.WriteLine("Pacjent: {0}", patient.Name);
                }
            }

            // LINQ to SQL

            var hospitalCtx = new HospitalDataContext();

            var docs =
                from doctor in hospitalCtx.HospitalStaffs
                where doctor.Position == "Doctor"
                select doctor;

            foreach (var doc in docs)
            {
                Console.WriteLine("Lekarz: {0}", doc.Name);
            }

            // Dodawanie

            //hospitalCtx.HospitalStaffs.InsertOnSubmit(
            //    new HospitalStaff { Name = "Jan", Position = "Lekarz" });

            // Aktualizacja

            //IQueryable<HospitalStaff> doctorsToUpdate =
            //    from doctor in hospitalCtx.HospitalStaffs
            //    where doctor.Name == "Marek"
            //    select doctor;

            //doctorsToUpdate.First().Name = "dr Marek";
            ////doctorsToUpdate.First().Position = "Pielegniarka";

            // Usuwanie

            //IQueryable<HospitalStaff> doctorsToDelete =
            //    from doctor in hospitalCtx.HospitalStaffs
            //    where doctor.Name == "Filip"
            //    select doctor;

            //hospitalCtx.HospitalStaffs.DeleteOnSubmit(doctorsToDelete.First());

            // zatwierdzanie zmian

            hospitalCtx.SubmitChanges();

            var docModified =
                from doctor in hospitalCtx.HospitalStaffs
                where doctor.Position == "Lekarz"
                select doctor;

            foreach (var doc in docModified)
            {
                Console.WriteLine("Pracownik: {0}", doc.Name);
            }

            // procedury składowane

            var doctors = hospitalCtx.GetDoctors();
            
            foreach (var doc in doctors)
            {
                Console.WriteLine("Lekarz: {0}", doc.Name);
            }

            // funkcje

            var docNames = 
                from docName in hospitalCtx.Doctors()
                select docName.Name;

            foreach (var name in docNames)
            {
                Console.WriteLine("Imię lekarza: {0}", name);
            }

            // modyfikacje za pomocą procedur składowanych


            // standardowe operatory zapytań

            // operatory sortowania

            var staffRev =
                (from staff in hospitalStaff
                 select staff).Reverse();

            foreach (var staffMbr in staffRev)
            {
                Console.WriteLine(staffMbr.Name);
            }

            // operatory ustawiania

            hospitalStaff.Add(
                new StaffMember
                {
                    Name = "Marcela",
                    Position = "Pielegniarka"
                }
            );

            hospitalStaff.ForEach(
                staff => Console.WriteLine(
                    "Imię: {0}, Stanowisko: {1}",
                    staff.Name, staff.Position));

            var distinctStaff =
                (
                    from staff in hospitalStaff
                    select staff
                )
                .Distinct(new StaffMember());

            foreach (var staff in distinctStaff)
            {
               Console.WriteLine(
                    "Imię: {0}, Stanowisko: {1}",
                    staff.Name, staff.Position);
            }

            hospitalStaff.Add(
                new TempStaffMember
                {
                    Name = "Patrycja",
                    Position = "Internista środowiskowy"
                }
            );

            var ofTypeStaff =
                (
                    from staff in hospitalStaff
                    select staff
                )
                .OfType<TempStaffMember>();

            foreach (var ofTypeMbr in ofTypeStaff)
            {
                Console.WriteLine("Imię: {0}", ofTypeMbr.Name);
            }

            bool anyVeterinarians =
                (
                    from staff in hospitalStaff
                    select staff
                )
                .Any(staff => staff.Position == "Weterynarz");

            Console.WriteLine("Czy są tu jacyś weterynarze? {0}", anyVeterinarians);

            var manyPatients =
                hospitalCtx.HospitalStaffs.SelectMany(
                    staff => staff.Patients);

            foreach (var patient in patients)
            {
                Console.WriteLine("Imię pacjenta: {0}", patient.Name);
            }

            int startRecord = 0;
            int recordsPerPage = 3;

            var page = hospitalStaff
                .Skip(startRecord)
                .Take(recordsPerPage);

            foreach (var staff in page)
            {
                Console.WriteLine("Pracownik zespołu: {0}", staff.Name);
            }

            var groupJoinStaff =
                hospitalCtx.HospitalStaffs.GroupJoin(
                    hospitalCtx.Patients,
                    staff => staff,
                    patient => patient.HospitalStaff,
                    (staff, patientList) =>
                         new
                         {
                             StaffMemberName = staff.Name,
                             Patients = patientList
                         });

            foreach (var staff in groupJoinStaff)
            {
                Console.WriteLine("Lekarz: {0}: ", staff.StaffMemberName);
                foreach (var patient in staff.Patients)
                {
                    Console.WriteLine("    Pacjent: {0}", patient.Name);
                }
            }

            var lookup =
                hospitalStaff.ToLookup(staff => staff.Position);

            foreach (var lkUp in lookup)
            {
                Console.WriteLine("Klucz: {0}", lkUp.Key);

                foreach (var staff in lkUp)
                {
                    Console.WriteLine("    Imię: {0}", staff.Name);
                    
                }
            }

            var repeatedPatients =
                Enumerable.Repeat<PatientObject>(
                    new PatientObject
                    {
                        Name = "Jan",
                        Doctor = "Marek"
                    },
                    20
                );

            foreach (var patient in repeatedPatients)
            {
                Console.WriteLine("Powtarzające się imię pacjenta: {0}", patient.Name);
            }

            var staffMemberCopy = new List<StaffMember>
            {
                new StaffMember { Name = "Marek", Position="Lekarz" },
                new StaffMember { Name = "Natalia", Position = "Pielegniarka" },
                new StaffMember { Name = "Marcela", Position = "Pielegniarka" }
            };

            bool areEqual = 
                hospitalStaff.SequenceEqual(staffMemberCopy);

            Console.WriteLine("SequenceEqual: {0}", areEqual);

            var doctorHyde =
                hospitalStaff.SingleOrDefault(
                    staff => 
                        staff.Name == "Hyde" && 
                        staff.Position == "Lekarz");

            hospitalStaff.ToList().ForEach(
                staff => Console.WriteLine(
                    "Nazwa listy: {0}", staff.Name));

            var concatStaff = hospitalStaff.Concat(staffMemberCopy);

            foreach (var staff in concatStaff)
            {
                Console.WriteLine("Nazwa połączona: {0}", staff.Name);
            }

            int numberOfStaff =
                (
                    from doc in hospitalStaff
                    where doc.Position == "Lekarz"
                    select doc
                )
                .Count();

            Console.ReadKey();
        }
    }
}
